#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_ReferenceData : BaseTest 
	{

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
		}

		[Test]
		public void GetUnitStatus_Pass()
		{
			DataRow dr = BOL.ReferenceData.GetUnitStatus(Common.Utility.GetUnitStatusCodeCharFromEnum(Common.UnitStatusCode.Available).ToString());
			Assert.AreEqual(Common.UnitStatusCode.Available,Common.Utility.GetUnitStatusCodeFromString(dr[TABLES.UnitStatus.UnitStatusCode].ToString()),"AvailableStatus");
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetUnitStatus_Fail()
		{
			DataRow dr = BOL.ReferenceData.GetUnitStatus("!");
			Assert.AreEqual("!",dr[TABLES.UnitStatus.UnitStatusCode].ToString(),"InvalidStatus");
		}

		[Test]
		public void GetUnitStatusList_Pass()
		{
			DataTable dt = BOL.ReferenceData.GetUnitStatusList();
			Assert.AreEqual(9,dt.Rows.Count,"Rows.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetUnitStatusList_Fail()
		{
		}

		[Test]
		public void GetBloodType_Pass()
		{
			DataRow dr = BOL.ReferenceData.GetBloodType(Common.Utility.GetAboFromEnum(Common.ABO.AB));
			Assert.AreEqual(Common.ABO.AB,Common.Utility.GetAboFromString(dr[TABLES.BloodType.BloodTypeCode].ToString()),"ABBloodType");
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetBloodType_Fail()
		{
			DataRow dr = BOL.ReferenceData.GetBloodType("!");
			Assert.AreEqual("!",dr[TABLES.BloodType.BloodTypeCode].ToString(),"InvalidBloodType");
		}

		[Test]
		public void GetAntigenType_Pass()
		{
			DataRow dr = BOL.ReferenceData.GetAntigenType(1);
			Assert.AreEqual(1,Convert.ToInt32(dr[TABLES.AntigenType.AntigenTypeId]),"AntigenTypeA");
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetAntigenType_Fail()
		{
			DataRow dr = BOL.ReferenceData.GetAntigenType(0);
			Assert.AreEqual(0,Convert.ToInt32(dr[TABLES.AntigenType.AntigenTypeId]),"InvalidAntigenType");
		}

		[Test]
		public void GetComponentClass_Pass()
		{
			DataRow dr = BOL.ReferenceData.GetComponentClass(1);
			Assert.AreEqual(1,Convert.ToInt16(dr[TABLES.ComponentClass.ComponentClassId]),"RBCComponentClass");
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetComponentClass_Fail()
		{
			DataRow dr = BOL.ReferenceData.GetComponentClass(0);
			Assert.AreEqual(0,Convert.ToInt16(dr[TABLES.ComponentClass.ComponentClassId]),"InvalidComponentClass");
		}

		[Test]
		public void GetLockFunction_Pass()
		{
			DataRow dr = BOL.ReferenceData.GetLockFunction(Common.LockFunctions.UnitTests);
			Assert.AreEqual(Common.LockFunctions.UnitTests,(Common.LockFunctions)Convert.ToInt32(dr[TABLES.VbecsLockFunction.VbecsFunctionId]),"UnitTestsLockFunction");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetLockFunction_Fail()
		{
		}

		[Test]
		public void GetLockFunctionList_Pass()
		{
			Assert.IsNotNull(BOL.ReferenceData.GetLockFunctionList(),"LockFunctionList");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetLockFunctionList_Fail()
		{
		}

		[Test]
		public void GetSpecimenStatus_Pass()
		{
			DataRow dr = BOL.ReferenceData.GetSpecimenStatus("R");
			Assert.AreEqual(Common.SpecimenStatus.Required,Common.Utility.GetSpecimenStatusCodeFromString(dr[TABLES.SpecimenStatus.SpecimenStatusCode].ToString()),"SpecimenStatusRequired");
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetSpecimenStatus_Fail()
		{
			DataRow dr = BOL.ReferenceData.GetSpecimenStatus("!");
			Assert.AreEqual("!",dr[TABLES.SpecimenStatus.SpecimenStatusCode].ToString(),"InvalidSpecimenStatus");
		}

		[Test]
		public void GetSpecimenStatusList_Pass()
		{
			DataTable dt = BOL.ReferenceData.GetSpecimenStatusList();
			Assert.AreEqual(3,dt.Rows.Count,"Rows.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetSpecimenStatusList_Fail()
		{
		}

		[Test]
		public void GetTaskStatus_Pass()
		{
			DataRow dr = BOL.ReferenceData.GetTaskStatus(Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.InProgress).ToString());
			Assert.AreEqual(Common.TaskStatus.InProgress,Common.Utility.GetTaskStatusCodeFromString(dr[TABLES.TaskStatus.TaskStatusCode].ToString()),"InProgressTaskStatus");
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetTaskStatus_Fail()
		{
			DataRow dr = BOL.ReferenceData.GetTaskStatus("!");
			Assert.AreEqual("!",dr[TABLES.TaskStatus.TaskStatusCode].ToString(),"InvalidTaskStatus");
		}

		[Test]
		public void GetTaskStatusList_Pass()
		{
			DataTable dt = BOL.ReferenceData.GetTaskStatusList();
			Assert.AreEqual(8,dt.Rows.Count,"Rows.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTaskStatusList_Fail()
		{
		}

		[Test]
		public void GetProductModification_Pass()
		{
			DataRow dr = BOL.ReferenceData.GetProductModification(Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Irradiated).ToString());
			Assert.AreEqual(Common.ProductModification.Irradiated,Common.Utility.GetProductModificationCodeFromString(dr[TABLES.ProductModification.ProductModificationCode].ToString()),"IrradiatedProductMod");
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetProductModification_Fail()
		{
			DataRow dr = BOL.ReferenceData.GetProductModification("!");
			Assert.AreEqual("!",dr[TABLES.ProductModification.ProductModificationCode].ToString(),"InvalidProductMod");
		}

		[Test]
		public void GetProductModificationList_Pass()
		{
			DataTable dt = BOL.ReferenceData.GetProductModificationList();
			Assert.AreEqual(11,dt.Rows.Count,"Rows.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetProductModificationList_Fail()
		{
		}

		[Test]
		public void GetTestingMethodList_Pass()
		{
			DataTable dt = BOL.ReferenceData.GetTestingMethodList();
			Assert.AreEqual(5,dt.Rows.Count,"Rows.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTestingMethodList_Fail()
		{
		}

		[Test]
		public void GetStateCodes_Pass()
		{
			string[] states = BOL.ReferenceData.GetStateCodes();
			Assert.IsTrue(states.Length>50,"StateCodes");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetStateCodes_Fail()
		{
		}

		[Test]
		public void GetTestResultList_Pass()
		{
			DataTable dt = BOL.ReferenceData.GetTestResultList();
			Assert.AreEqual(23,dt.Rows.Count,"Rows.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTestResultList_Fail()
		{
		}

		[Test]
		public void GetTimeZone_Pass()
		{
			DataRow dr = BOL.ReferenceData.GetTimeZone("Z");
			Assert.AreEqual("Z",dr[TABLES.TimeZone.TimeZoneId].ToString(),"UTCTimeZone");
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetTimeZone_Fail()
		{
			DataRow dr = BOL.ReferenceData.GetTimeZone("!");
			Assert.AreEqual("!",dr[TABLES.TimeZone.TimeZoneId].ToString(),"InvalidTimeZone");
		}

		[Test]
		public void GetTransfusionReactionTypeList_Pass()
		{
			DataTable dt = BOL.ReferenceData.GetTransfusionReactionTypeList();
			Assert.AreEqual(14,dt.Rows.Count,"Rows.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTransfusionReactionTypeList_Fail()
		{
		}

		[Test]
		public void GetTransfusionReactionType_Pass()
		{
			DataRow dr = BOL.ReferenceData.GetTransfusionReactionType('F');
			Assert.AreEqual("F",dr[TABLES.TransfusionReactionType.TransfusionReactionTypeCode].ToString(),"FebrileTrxReaction");
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetTransfusionReactionType_Fail()
		{
			DataRow dr = BOL.ReferenceData.GetTransfusionReactionType('!');
			Assert.AreEqual("!",dr[TABLES.TransfusionReactionType.TransfusionReactionTypeCode].ToString(),"InvalidTrxReaction");
		}

		[Test]
		public void GetOrderableTestList_Pass()
		{
			DataTable dt = BOL.ReferenceData.GetOrderableTestList();
			Assert.IsTrue(dt.Rows.Count>0,"Rows.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetOrderableTestList_Fail()
		{
		}

		[Test]
		public void GetOrderableTest_Pass()
		{
			DataRow dr = BOL.ReferenceData.GetOrderableTest((int)Common.OrderableTest.RepeatXM);
			Assert.AreEqual(Common.OrderableTest.RepeatXM,(Common.OrderableTest)Convert.ToInt32(dr[TABLES.OrderableTest.OrderableTestId]),"RepeatXMOrderableTest");
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetOrderableTest_Fail()
		{
			DataRow dr = BOL.ReferenceData.GetOrderableTest(0);
			Assert.AreEqual(0,Convert.ToInt32(dr[TABLES.OrderableTest.OrderableTestId]),"InvalidOrderableTest");
		}

		[Test]
		public void GetReactivityPhaseList_Pass()
		{
			DataTable dt = BOL.ReferenceData.GetReactivityPhaseList();
			Assert.AreEqual(9,dt.Rows.Count,"Rows.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetReactivityPhaseList_Fail()
		{
		}

		[Test]
		public void GetReactivityPhase_Pass()
		{
			DataRow dr = BOL.ReferenceData.GetReactivityPhase((int)Common.ReactivityPhase.All);
			Assert.AreEqual(Common.ReactivityPhase.All,(Common.ReactivityPhase)Convert.ToInt32(dr[TABLES.ReactivityPhase.ReactivityPhaseCode]),"AllReactivityPhases");
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetReactivityPhase_Fail()
		{
			DataRow dr = BOL.ReferenceData.GetReactivityPhase(0);
			Assert.AreEqual(0,Convert.ToInt32(dr[TABLES.ReactivityPhase.ReactivityPhaseCode]),"InvalidReactivityPhase");
		}

		[Test]
		public void GetProductTypeList_Pass()
		{
			DataTable dt = BOL.ReferenceData.GetProductTypeList();
			Assert.IsTrue(dt.Rows.Count>0,"Rows.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetProductTypeList_Fail()
		{
		}

		[Test]
		public void GetProductType_Pass()
		{
			DataRow dr = BOL.ReferenceData.GetProductType(Common.Utility.GetProductTypeCodeFromProductTypeEnum(Common.ProductType.ApheresisRedBloodCells));
			Assert.AreEqual(Common.ProductType.ApheresisRedBloodCells,Common.Utility.GetProductTypeFromProductTypeCode(dr[TABLES.ProductType.ProductTypeCode].ToString()),"ApherRBCProductType");
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetProductType_Fail()
		{
			DataRow dr = BOL.ReferenceData.GetProductType("!");
			Assert.AreEqual("!",dr[TABLES.ProductType.ProductTypeCode].ToString(),"InvalidProductType");
		}
	}
}
#endif
